//================================================================================
// WheeledCar1.
//================================================================================

class MSWheeledCar extends MSDrivables;

#exec MESH IMPORT MESH=WheeledCar1 ANIVFILE=C:\DeusEx\MSDriving1_2\Models\WheeledCar1_a.3d DATAFILE=C:\DeusEx\MSDriving1_2\Models\WheeledCar1_d.3d X=0 Y=0 Z=0
//#exec MESH ORIGIN MESH=WheeledCar1 X=0 Y=0 Z=0 PITCH=0 ROLL=0 YAW=-64
#exec MESH ORIGIN MESH=WheeledCar1 X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=WheeledCar1 SEQ=All    STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=WheeledCar1 SEQ=WheeledCar1 STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=WheeledCarRed FILE=C:\DeusEx\MSDriving1_2\Textures\WheeledCarRed.PCX GROUP=Skins
#exec TEXTURE IMPORT NAME=WheeledCarYellow FILE=C:\DeusEx\MSDriving1_2\Textures\WheeledCarYellow.PCX GROUP=Skins
#exec TEXTURE IMPORT NAME=WheeledCarBlue FILE=C:\DeusEx\MSDriving1_2\Textures\WheeledCarBlue.PCX GROUP=Skins
#exec TEXTURE IMPORT NAME=WheeledCarGreen FILE=C:\DeusEx\MSDriving1_2\Textures\WheeledCarGreen.PCX GROUP=Skins

#exec MESHMAP NEW   MESHMAP=WheeledCar1 MESH=WheeledCar1
#exec MESHMAP SCALE MESHMAP=WheeledCar1 X=0.00990625 Y=0.00990625 Z=0.00990625

#exec MESHMAP SETTEXTURE MESHMAP=WheeledCar1 NUM=0 TEXTURE=WheeledCarRed

enum ESkinColor {
	SC_WheeledCarRed,
	SC_WheeledCarBlue,
	SC_WheeledCarYellow,
	SC_WheeledCarGreen
};

var() ESkinColor SkinColor;

function BeginPlay ()
{
	Super.BeginPlay();
	switch (SkinColor)
	{
		case SC_WheeledCarRed:
		Skin = Texture'WheeledCarRed';
		break;
		case SC_WheeledCarBlue:
		Skin = Texture'WheeledCarBlue';
		break;
		case SC_WheeledCarYellow:
		Skin = Texture'WheeledCarYellow';
		break;
		case SC_WheeledCarGreen:
		Skin = Texture'WheeledCarGreen';
		break;
		default:
	}
}

defaultproperties
{
     ItemName="Car"
     Texture=Texture'Skins.WheeledCarRed'
     Mesh=LodMesh'MSDriving1_2.WheeledCar1'
     DrawScale=4.90
     CollisionRadius=120.00
     CollisionHeight=40.00
     Mass=6000.00
     Buoyancy=1000.00
     CarSpeed=6
     BrakeStrength=6
     MSAccelerationSpeed=5
     TopGas=6
     LeftGunPos=(X=111.500000,Y=70.905579,Z=14.712852)
     RightGunPos=(X=111.500000,Y=-70.905579,Z=14.712852)
     LRPGPos=(X=128.500000,Y=70.905579,Z=24.712852)
     RRPGPos=(X=128.500000,Y=-70.905579,Z=24.712852)
     DriverPos=(X=0,Y=-24,Z=9.25)
     PassengerPos=(X=0,Y=24,Z=9.25)
     FiringOffsetR=(X=37.5,Y=0,Z=0)
     FiringOffsetL=(X=37.5,Y=0,Z=0)
     bOwnerNoSee=True
     DriverDump=(X=0,Y=85.5,Z=0)
     PassengerDump=(X=0,Y=-85.5,Z=0)

}